<?php $__env->startSection('content'); ?>
    <div class="container-fluid mb-2">
        <?php if($message = Session::get('success')): ?>
            <div class="col-lg-6 alert alert-success" id="successMessage">
                <p><?php echo e($message); ?></p>
            </div>
        <?php endif; ?>
        <div class="row justify-content-center">
            <div class="card">
                <div class="card-body">

                    <div class="row p-3">
                        <div class="col-md-6">
                            <form action="<?php echo e(route('user.index')); ?>" method="GET">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control shadow-none"
                                        placeholder="Search by name, email, or contact"
                                        value="<?php echo e(request()->input('search')); ?>">
                                    <button type="submit" class="btn btn-primary shadow-none">Search</button>
                                    <a href="<?php echo e(route('user.index')); ?>" class="btn btn-secondary shadow-none">Reset</a>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-6 text-end">
                            <a href="<?php echo e(route('user.trash')); ?>" class="btn btn-warning me-2">Go to Trash</a>
                            <a href="<?php echo e(route('user.create')); ?>" class="btn btn-primary">Add User</a>
                        </div>
                    </div>
                    <?php if(count($users) !== 0): ?>
                        <div class="table-responsive">
                            <table class="table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Conatct</th>
                                        <th>User Type</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($item->name); ?></td>
                                            <td><?php echo e($item->email); ?></td>
                                            <td><?php echo e($item->contact); ?></td>
                                            <td><?php echo e($item->type); ?></td>
                                            <td>
                                                <?php if($item->type != 'admin'): ?>
                                                <div class="d-flex gap-2 justify-content-center">
                                                    <div>
                                                        <a href="<?php echo e(route('user.edit', $item->id)); ?>"
                                                            class="btn btn-primary shadow-none mb-2 ">Edit</a>
                                                    </div>
                                                    <div>
                                                        <button class="delete-user btn btn-danger shadow-none"
                                                            data-id="<?php echo e($item->id); ?>">Delete</button>
                                                    </div>
                                                    <div>
                                                        <a href="<?php echo e(route('user.resetPassword')); ?>/<?php echo e($item->id); ?>" class="btn btn-primary shadow-none mb-2 " title="Reset Password to Default(123456)">Reset Password</a>
                                                    </div>

                                                </div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info col-lg-6">
                            <p class="text-center">No users found.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php echo $users->withQueryString()->links('pagination::bootstrap-5'); ?>

    <script>
        const deleteButtons = document.querySelectorAll('.delete-user');

        deleteButtons.forEach(button => {
            button.addEventListener('click', (e) => {
                e.preventDefault();
                const userId = e.target.getAttribute('data-id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You won\'t be able to revert this!',
                    icon: 'warning', //question, error, warning, success, info

                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Redirect to a route that handles user deletion
                        window.location.href = `/user/delete/${userId}`;
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\flipcode\laravel\MSOnline(UmangBhai)\resources\views/user/index.blade.php ENDPATH**/ ?>