<?php $__env->startSection('content'); ?>
    <section class="section">
        
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row m-0 p-3">
                            <div class="col-lg-6">
                                <h3>
                                    <?php if(count($sliders) > 0): ?>
                                        Slider Trash List
                                    <?php else: ?>
                                        There are no trash data to show
                                    <?php endif; ?>
                                </h3>
                            </div>
                            <div class="col-lg-6 d-flex justify-content-end align-items-center">
                                <span style="float:right;"><a href="<?php echo e(route('slider.index')); ?>"
                                        class="btn btn-primary">Back</a>
                                </span>
                            </div>
                        </div>
                        <!-- SKU List Table -->

                        <?php if(count($sliders) !== 0): ?>
                            <table id="slider-table" class="table table-bordered text-center">
                                <thead class="table-secondary">
                                    <tr>
                                        <th>Slider Image</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            

                                            <td><img src="<?php echo e(asset('slider/' . $slider->image)); ?>" width="50"
                                                    height="50"></td>


                                            <td>
                                                <div class="d-flex gap-2 justify-content-center">
                                                    <div>
                                                        <a href="<?php echo e(route('slider.restore', $slider->id)); ?>"
                                                            class="btn btn-primary btn-sm shadow-none mb-2 ">Restore</a>
                                                    </div>
                                                    <div>
                                                        <button class="delete-user btn btn-danger btn-sm shadow-none"
                                                            data-id="<?php echo e($slider->id); ?>">Delete</button>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Pagination Links -->
        <?php echo $sliders->withQueryString()->links('pagination::bootstrap-5'); ?>

        <script>
            const deleteButtons = document.querySelectorAll('.delete-user');

            deleteButtons.forEach(button => {
                button.addEventListener('click', (e) => {
                    e.preventDefault();
                    const userId = e.target.getAttribute('data-id');

                    Swal.fire({
                        title: 'Are you sure?',
                        text: 'You won\'t be able to revert this!',
                        icon: 'warning', //question , error , warning , success , info

                        showCancelButton: true,
                        confirmButtonColor: '#d33',
                        cancelButtonColor: '#3085d6',
                        confirmButtonText: 'Yes, permanently delete  it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirect to a route that handles user deletion
                            window.location.href = `/slider/force-delete/${userId}`;
                            Swal.fire('Deleted!', 'Deleted Successfully.', 'success');
                        }
                    });
                });
            });
        </script>

        <script>
            const skuRestore = document.querySelectorAll('.sku-restore');

            skuRestore.forEach(button => {
                button.addEventListener('click', (e) => {
                    e.preventDefault();
                    const userId = e.target.getAttribute('data-id');

                    Swal.fire({
                        title: 'Are you sure?',
                        text: 'You want to restore this slider ?',
                        icon: 'question', //question , error , warning , success , info

                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Yes, restore it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirect to a route that handles user deletion
                            window.location.href = `/slider/restore/${userId}`;
                            Swal.fire({
                                title: 'Restored!',
                                text: 'Sldier Restored Successfully.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.href = `/slider/restore/${userId}`;
                                    Swal.fire('Restored!', 'Slider Restored Successfully.',
                                        'success');
                                }
                            });
                        }
                    });
                });
            });
        </script>

    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\flipcode\laravel\MSOnline(UmangBhai)\resources\views/slider/trash.blade.php ENDPATH**/ ?>