<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php if(session()->has('success')): ?>
            <script>
                Swal.fire(
                    'Success!',
                    '<?php echo e(session('success')); ?>',
                    'success'
                );
            </script>
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row p-3">
                            <div class="col-lg-6">
                                <h3 id="ordersList-heading">
                                    Order List
                                </h3>
                            </div>
                            <div class="col-lg-6 d-flex justify-content-end align-items-center">
                                <div class="d-flex justify-content-end">
                                    <span class="text-danger"><strong>* You can update the Order Status by clicking on the
                                            respective field.</strong></span>
                                </div>
                            </div>
                            <div class="col-lg-6 d-flex justify-content-end align-items-center">
                                
                                
                            </div>
                        </div>
                        <form action="<?php echo e(route('orders.index')); ?>" method="get">
                            <div class="row py-3">
                                <div class="col-md-3">
                                    <select name="orderStatus" class="form-select">
                                        <option disabled <?php echo e(request('orderStatus') == null ? 'selected' : ''); ?>>select order
                                            status</option>
                                        <option value="Confirm" <?php echo e(request('orderStatus') == 'Confirm' ? 'selected' : ''); ?>>
                                            Confirm</option>
                                        <option value="Shipped" <?php echo e(request('orderStatus') == 'Shipped' ? 'selected' : ''); ?>>
                                            Shipped</option>
                                        <option value="Out for Delivery"
                                            <?php echo e(request('orderStatus') == 'Out for Delivery' ? 'selected' : ''); ?>>Out for
                                            Delivery</option>
                                        <option value="Delivered"
                                            <?php echo e(request('orderStatus') == 'Delivered' ? 'selected' : ''); ?>>Delivered</option>
                                        <option value="Cancelled"
                                            <?php echo e(request('orderStatus') == 'Cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                    </select>
                                </div>
                                <div class="col-md-3">
                                    <input type="text" placeholder="Enter Product Name" name="productName"
                                        class="form-control" value="<?php echo e(request('productName')); ?>" />
                                </div>
                                <div class="col-md-3">
                                        <input type="text" placeholder="Enter Name" name="userName" class="form-control"
                                            value="<?php echo e(request('userName')); ?>" />
                                    
                                </div>

                                <div class="col-md-3">
                                    <input type="submit" class="btn btn-primary shadow-none" value="Filter" />
                                    <a href="<?php echo e(route('orders.index')); ?>" class="btn btn-primary shadow-none">Reset</a>
                                </div>
                            </div>
                        </form>

                        <?php if(count($orders) !== 0): ?>
                            <table id="slider-table" class="table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>User Name</th>
                                        <th>Address</th>
                                        <th>Payment ID</th>
                                        <th>Product Name</th>
                                        <th>Quantity</th>
                                        <th>Order Status</th>
                                        <th>Price</th>
                                        <th>Total Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e($order->order->users->name ?? '-'); ?></td>
                                            <td style="width: 300px"><?php echo e(nl2br($order->customer_address ?? '-')); ?></td>
                                            <td><?php echo e($order->order->payment_id ?? '-'); ?></td>
                                            <td><?php echo e($order->product->slug ?? '-'); ?></td>
                                            <td><?php echo e($order->quantity ?? '-'); ?></td>
                                            <td style="width: 120px">
                                                <select class="form-control order-status"
                                                    data-order-id="<?php echo e($order->id); ?>">
                                                    <option value="Confirm"
                                                        <?php echo e($order->orderStatus == 'Confirm' ? 'selected' : ''); ?>>Confirm
                                                    </option>
                                                    <option value="Shipped"
                                                        <?php echo e($order->orderStatus == 'Shipped' ? 'selected' : ''); ?>>Shipped
                                                    </option>
                                                    <option value="Out for Delivery"
                                                        <?php echo e($order->orderStatus == 'Out for Delivery' ? 'selected' : ''); ?>>
                                                        Out for Delivery</option>
                                                    <option value="Delivered"
                                                        <?php echo e($order->orderStatus == 'Delivered' ? 'selected' : ''); ?>>
                                                        Delivered</option>
                                                    <option value="Cancelled"
                                                        <?php echo e($order->orderStatus == 'cancelled' ? 'selected' : ''); ?>>
                                                        Cancelled</option>
                                                </select>
                                            </td>
                                            <td><?php echo e($order->price ?? '-'); ?></td>
                                            <td><?php echo e($order->order->amount ?? '-'); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- Pagination Links -->
        <?php echo $orders->withQueryString()->links('pagination::bootstrap-5'); ?>


    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.order-status').forEach(function(selectElement) {
                selectElement.addEventListener('change', function() {
                    var orderId = this.getAttribute('data-order-id');
                    var newStatus = this.value;

                    fetch(`/orders/${orderId}/update-status`, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            },
                            body: JSON.stringify({
                                orderStatus: newStatus
                            })
                        })
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Network response was not ok ' + response
                                    .statusText);
                            }
                            return response.json();
                        })
                        .then(data => {
                            if (data.success) {
                                Swal.fire(
                                    'Updated!',
                                    'Order status has been updated.',
                                    'success'
                                );
                            } else {
                                Swal.fire(
                                    'Error!',
                                    'There was an error updating the order status.',
                                    'error'
                                );
                            }
                        })
                        .catch(error => {
                            console.error('There was a problem with the fetch operation:',
                                error);
                            Swal.fire(
                                'Error!',
                                'There was a problem with the fetch operation.',
                                'error'
                            );
                        });
                });
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\flipcode\laravel\MSOnline(UmangBhai)\resources\views/order/orders.blade.php ENDPATH**/ ?>