<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php if(session()->has('success')): ?>
            <script>
                Swal.fire(
                    'Success!',
                    '<?php echo e(session('success')); ?>',
                    'success'
                );
            </script>
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row p-3">
                            <div class="col-lg-6">
                                <h3>
                                    <?php if(count($sliders) > 0): ?>
                                        Slider List
                                    <?php else: ?>
                                        There are no data to show
                                    <?php endif; ?>
                                </h3>
                            </div>
                            <div class="col-lg-6 d-flex justify-content-end align-items-center">
                                <span style="float:right;"><a href="<?php echo e(route('slider.trash')); ?>"
                                        class="btn btn-warning shadow-none me-2">Go To Trash</a>
                                </span>
                                <span style="float:right;"><a href="<?php echo e(route('slider.create')); ?>"
                                        class="btn btn-primary shadow-none">Add
                                        Slider</a>
                                </span>
                            </div>
                        </div>
                        <!-- SKU List Table -->

                        <?php if(count($sliders) !== 0): ?>
                            <table id="slider-table" class="table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th>Slider Image</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            

                                            <td><img src="<?php echo e(asset('slider/' . $slider->image)); ?>" width="50"
                                                    height="50"></td>


                                            <td>
                                                <div class="d-flex gap-2 justify-content-center">
                                                    <div>
                                                        <button class="delete-user btn btn-danger btn-sm shadow-none"
                                                            data-id="<?php echo e($slider->id); ?>">Delete</button>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- Pagination Links -->
        <?php echo $sliders->withQueryString()->links('pagination::bootstrap-5'); ?>


        <script>
            const deleteButtons = document.querySelectorAll('.delete-user');

            deleteButtons.forEach(button => {
                button.addEventListener('click', (e) => {
                    e.preventDefault();
                    const userId = e.target.getAttribute('data-id');

                    Swal.fire({
                        title: 'Are you sure?',
                        text: 'You can revert this action from trash!',
                        icon: 'warning', //question , error , warning , success , info

                        showCancelButton: true,
                        confirmButtonColor: '#d33',
                        cancelButtonColor: '#3085d6',
                        confirmButtonText: 'Yes, delete it!'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Redirect to a route that handles user deletion
                            window.location.href = `/slider/delete/${userId}`;
                            Swal.fire('Deleted!', 'Moved to trash Successfully.', 'success');
                        }
                    });
                });
            });
        </script>

    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\flipcode\laravel\MSOnline(UmangBhai)\resources\views/slider/index.blade.php ENDPATH**/ ?>