<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php if(session()->has('success')): ?>
            <script>
                Swal.fire(
                    'Success!',
                    '<?php echo e(session('success')); ?>',
                    'success'
                );
            </script>
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row p-3">
                            <div class="col-lg-6">
                                <h3>
                                    <?php if(count($skus) > 0): ?>
                                        SKU List
                                    <?php else: ?>
                                        There are no data to show
                                    <?php endif; ?>
                                </h3>
                            </div>
                            <div class="col-lg-6 d-flex justify-content-end mb-3">
                                <span style="float:right;"><a href="<?php echo e(route('sku.trash')); ?>"
                                        class="btn btn-warning shadow-none me-2">Go To Trash</a>
                                </span>
                                <span style="float:right;"><a href="<?php echo e(route('sku.create')); ?>"
                                        class="btn btn-primary shadow-none">Add
                                        SKU</a>
                                </span>
                            </div>
                            <!-- SKU List Table -->

                            <?php if(count($skus) !== 0): ?>
                                <table id="sku-table" class="table table-bordered  text-center mt-3">
                                    <thead>
                                        <tr>
                                            <th>Prefix</th>
                                            <th>Color Name</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $skus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sku): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($sku->prefix); ?></td>
                                                <td><?php echo e($sku->colorname); ?></td>
                                                <td>
                                                    <div class="d-flex gap-2 justify-content-center">
                                                        <div>
                                                            <a href="<?php echo e(route('sku.edit', $sku->id)); ?>"
                                                                class="btn btn-primary btn-sm shadow-none mb-2 ">Edit</a>
                                                        </div>
                                                        <div>
                                                            <button class="delete-user btn btn-danger btn-sm shadow-none"
                                                                data-id="<?php echo e($sku->id); ?>">Delete</button>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- Pagination Links -->
                <?php echo $skus->withQueryString()->links('pagination::bootstrap-5'); ?>


                <script>
                    const deleteButtons = document.querySelectorAll('.delete-user');

                    deleteButtons.forEach(button => {
                        button.addEventListener('click', (e) => {
                            e.preventDefault();
                            const userId = e.target.getAttribute('data-id');

                            Swal.fire({
                                title: 'Are you sure?',
                                text: 'You can revert this action from trash!',
                                icon: 'warning', //question , error , warning , success , info

                                showCancelButton: true,
                                confirmButtonColor: '#d33',
                                cancelButtonColor: '#3085d6',
                                confirmButtonText: 'Yes, delete it!'
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    // Redirect to a route that handles user deletion
                                    window.location.href = `/sku/delete/${userId}`;
                                    Swal.fire('Deleted!', 'Moved to trash Successfully.', 'success');
                                }
                            });
                        });
                    });
                </script>

    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\flipcode\laravel\MSOnline(UmangBhai)\resources\views/sku/index.blade.php ENDPATH**/ ?>